<?php

/*
 * @copyright   2018 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Mautic\LeadBundle\Segment;

/**
 * Class RandomParameterName.
 */
class RandomParameterName
{
    /**
     * Contains randomly generated parameter names generated by
     * `generateRandomParameterName()`. This eliminates chances
     * for parameter name collision.
     *
     * @var array
     */
    private $usedParameterNames = [];

    /**
     * Generate a unique parameter name.
     *
     * @return string
     */
    public function generateRandomParameterName()
    {
        $alpha_numeric = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';

        $paramName = substr(str_shuffle($alpha_numeric), 0, 8);

        if (!in_array($paramName, $this->usedParameterNames, true)) {
            $this->usedParameterNames[] = $paramName;

            return $paramName;
        }

        return $this->generateRandomParameterName();
    }
}
